<?php
/*
===========================================================
 Random Prompt / Kreativitäts-Booster
 Idee & Umsetzung: Rainer Wieding – https://thecodeatlas.net
 Technische Unterstützung: ChatGPT (OpenAI)
===========================================================
*/
error_reporting(E_ALL);
ini_set('display_errors', 1);

/* --------------------------------------------------------
   Prompt-Bausteine
---------------------------------------------------------*/
$categories = [
    'all'        => '🎲 Mix aus allem',
    'content'    => '✍️ Content & Blogging',
    'social'     => '📱 Social Media & Branding',
    'marketing'  => '📈 Marketing & Funnels',
    'product'    => '🧩 Produktideen & Features',
    'coding'     => '👨‍💻 Coding & Dev-Ideen',
];

$topics = [
    'content' => [
        'einen ausführlichen Blogartikel',
        'eine Schritt-für-Schritt-Anleitung',
        'eine Liste mit ungewöhnlichen Tipps',
        'eine FAQ-Sammlung mit klaren Antworten',
        'eine Story, die ein Learning vermittelt',
    ],
    'social' => [
        'eine Serie aus 5 Social-Media-Posts',
        'einen Hook für einen Reels-Clip',
        'eine LinkedIn-Post-Idee für Professionals',
        'eine Instagram-Carousel-Struktur',
        'einen witzigen Tweet-Thread',
    ],
    'marketing' => [
        'eine E-Mail für eine Launch-Sequenz',
        'eine Landingpage-Struktur mit Sektionen',
        'eine simple Funnel-Idee',
        'eine Upsell- oder Cross-Sell-Idee',
        'eine Remarketing-Kampagne',
    ],
    'product' => [
        'ein kleines digitales Produkt',
        'ein Mini-Tool oder Script für Webmaster',
        'einen bezahlten Newsletter / Micro-Subscription',
        'ein „Done-for-you“-Service-Angebot',
        'ein einfaches Template-Bundle',
    ],
    'coding' => [
        'ein kleines Code-Tool (PHP oder JS)',
        'ein SEO- oder Analyse-Script',
        'eine Micro-SaaS-Idee ohne Login',
        'ein Open-Source-Tool für GitHub',
        'ein praktisches Snippet für Entwickler',
    ],
];

$audiences = [
    'für absolute Einsteiger',
    'für leicht fortgeschrittene Anwender',
    'für erfahrene Profis',
    'für vielbeschäftigte Selbstständige',
    'für kleine Agenturen oder Freelancer-Teams',
];

$angles = [
    'mit Fokus auf schnelle Ergebnisse',
    'mit Fokus auf Klarheit und Einfachheit',
    'mit Fokus auf Storytelling und Emotion',
    'mit Fokus auf Fehler, die die Zielgruppe vermeiden sollte',
    'mit Fokus auf typische Einwände und wie man sie auflöst',
];

$tones = [
    'in einem lockeren, humorvollen Ton',
    'in einem sachlichen, professionellen Ton',
    'in einem sehr klaren, direkten Ton',
    'in einem inspirierenden, motivierenden Ton',
    'in einem leicht provokanten Ton',
];

$constraints = [
    'maximal 500 Wörter',
    'maximal 200 Wörter',
    'mit einer konkreten Call-to-Action am Ende',
    'mit einem starken Hook in den ersten 2 Sätzen',
    'mit mindestens einem konkreten Praxisbeispiel',
];

$contexts = [
    'im Kontext von Online-Marketing',
    'im Kontext von Webentwicklung / Coding',
    'im Kontext von SEO & Sichtbarkeit',
    'im Kontext von Content Creation und Social Media',
    'im Kontext von kleinen digitalen Produkten (E-Books, Tools, Templates)',
];

/* Hilfsfunktion: zufälliges Element aus Array */
function pick(array $arr): string {
    return $arr[array_rand($arr)];
}

/* Kategorie bestimmen */
$selectedCategory = $_POST['category'] ?? 'all';
if (!array_key_exists($selectedCategory, $categories)) {
    $selectedCategory = 'all';
}

/* Prompt generieren, falls Formular abgeschickt */
$generatedPrompt = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    // Themenliste passend zur Kategorie ermitteln
    if ($selectedCategory === 'all') {
        // Alle Topics zusammenwerfen
        $allTopics = [];
        foreach ($topics as $cat => $list) {
            $allTopics = array_merge($allTopics, $list);
        }
        $topic = pick($allTopics);
    } else {
        $topicList = $topics[$selectedCategory] ?? [];
        if (empty($topicList)) {
            // Fallback: alle
            $allTopics = [];
            foreach ($topics as $cat => $list) {
                $allTopics = array_merge($allTopics, $list);
            }
            $topic = pick($allTopics);
        } else {
            $topic = pick($topicList);
        }
    }

    $aud   = pick($audiences);
    $ang   = pick($angles);
    $tone  = pick($tones);
    $cons  = pick($constraints);
    $ctx   = pick($contexts);

    $generatedPrompt = "Erstelle {$topic} {$aud}, {$ang}, {$tone}. "
        ."Achte darauf, dass der Inhalt {$ctx} steht und {$cons}.";
}

?>
<!doctype html>
<html lang="de">
<head>
<meta charset="utf-8">
<title>Random Prompt / Kreativitäts-Booster – TheCodeAtlas</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<link rel="stylesheet"
      href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
<link rel="stylesheet"
      href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">

<style>
:root {
    --purple:#9c88ff;
    --cyan:#00a8ff;
    --bg:#050814;
    --card:#0b1020;
    --input-bg:#0f1629;
}
body {
    background: radial-gradient(circle at top, #151935 0, #050814 55%, #02040b 100%);
    color:#f5f7ff;
    font-family: system-ui,-apple-system,BlinkMacSystemFont,"Segoe UI",sans-serif;
    min-height:100vh;
}
.card-premium {
    background: radial-gradient(circle at 0 0, rgba(156,136,255,0.15), rgba(5,8,20,0.96));
    border-radius:1.4rem;
    border:1px solid rgba(255,255,255,0.06);
    padding:1.8rem;
    box-shadow:0 22px 55px rgba(0,0,0,0.55);
}
.form-label {
    font-weight:600;
    color:#dfe7ff;
    margin-bottom:0.4rem;
}
.form-select,
.form-control {
    background:var(--input-bg);
    border:1px solid rgba(255,255,255,0.16);
    color:#e9ecff !important;
    border-radius:0.9rem;
}
.form-select:focus,
.form-control:focus {
    background:#0f1931;
    border-color:var(--cyan);
    box-shadow:0 0 0 0.15rem rgba(0,168,255,0.35);
}
.form-select option {
    background:#050814;
    color:#e5e7ff;
}
.btn-premium {
    display:inline-block;
    background:linear-gradient(135deg,var(--purple),var(--cyan));
    border:none;
    border-radius:1rem;
    padding:0.9rem 1.8rem;
    font-weight:700;
    font-size:1.05rem;
    color:#050814 !important;
    text-decoration:none;
    box-shadow:0 8px 22px rgba(0,168,255,0.25);
}
.btn-premium:hover {
    opacity:0.92;
    transform:translateY(-1px);
}
.btn-premium:active {
    transform:translateY(1px);
}
.btn-outline-soft {
    border-radius:1rem;
    border:1px solid rgba(255,255,255,0.18);
    background:rgba(11,16,32,0.85);
    color:#e5e7ff;
}
.btn-outline-soft:hover {
    border-color:var(--cyan);
    color:#fff;
}
.hint {
    font-size:0.82rem;
    color:#a0a0a0;
}
.prompt-box {
    background:rgba(5,8,20,0.8);
    border-radius:1rem;
    border:1px solid rgba(148,163,184,0.35);
    padding:1rem 1.2rem;
    font-size:0.98rem;
    line-height:1.5;
}
.footer-box {
    text-align:center;
    margin-top:3rem;
    padding:1.5rem 0;
    color:#8a92b5;
    font-size:0.85rem;
}
.footer-box a {
    color:#b7beff;
    text-decoration:none;
}
.footer-box a:hover {
    text-decoration:underline;
}
</style>
</head>
<body>

<div class="container py-5">
    <h1 class="mb-1">
        <i class="fa-solid fa-wand-magic-sparkles me-2 text-info"></i>
        Random Prompt / Kreativitäts-Booster
    </h1>
    <p class="text-muted mb-3" style="color:#a0a0a0 !important;">
        Wenn dir gerade nichts einfällt: würfle dir frische Ideen für Content, Social Media, Marketing,
        Produkte oder Dev-Snippets.
    </p>

    <div class="row">
        <div class="col-lg-5 mb-4">
            <div class="card-premium h-100">
                <h2 class="h5 mb-3">
                    <i class="fa-solid fa-sliders me-2 text-warning"></i>
                    Kategorie & Einstellungen
                </h2>

                <form method="post" id="promptForm" class="mb-0">
                    <div class="mb-3">
                        <label class="form-label">Kategorie</label>
                        <select name="category" class="form-select">
                            <?php foreach ($categories as $key => $label): ?>
                                <option value="<?= htmlspecialchars($key) ?>"
                                    <?= $key === $selectedCategory ? 'selected' : '' ?>>
                                    <?= htmlspecialchars($label) ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                        <div class="hint">
                            „Mix aus allem“ kombiniert zufällig Content, Social, Marketing, Produkt und Coding.
                        </div>
                    </div>

                    <div class="hint mb-3">
                        Tipp: Wenn dir ein Prompt gefällt, klick auf „Prompt kopieren“ und leg dir eine eigene
                        kleine Ideensammlung an (Notion, Obsidian, etc.).
                    </div>

                    <div class="d-grid">
                        <button type="submit" class="btn-premium">
                            🎲 Prompt würfeln
                        </button>
                    </div>
                </form>
            </div>
        </div>

        <div class="col-lg-7 mb-4">
            <div class="card-premium h-100 d-flex flex-column">
                <div class="d-flex justify-content-between align-items-center mb-2">
                    <h2 class="h5 mb-0">
                        <i class="fa-solid fa-lightbulb me-2 text-success"></i>
                        Generierter Prompt
                    </h2>
                    <button type="button"
                            class="btn btn-sm btn-outline-soft"
                            onclick="copyPrompt()">
                        <i class="fa-regular fa-copy me-1"></i> Prompt kopieren
                    </button>
                </div>

                <?php if ($generatedPrompt): ?>
                    <div class="prompt-box mb-3" id="promptBox">
                        <?= htmlspecialchars($generatedPrompt) ?>
                    </div>
                <?php else: ?>
                    <div class="prompt-box mb-3" id="promptBox">
                        Beispiel:<br>
                        <em>
                            Erstelle einen ausführlichen Blogartikel für absolute Einsteiger, mit Fokus auf schnelle
                            Ergebnisse, in einem lockeren, humorvollen Ton. Achte darauf, dass der Inhalt im Kontext von
                            kleinen digitalen Produkten steht und maximal 500 Wörter umfasst.
                        </em>
                    </div>
                <?php endif; ?>

                <p class="hint mb-0">
                    Du kannst den Prompt 1:1 in ChatGPT, Claude, Gemini oder dein eigenes Notizsystem kopieren.
                    Kleine Anpassungen (Thema, Zielgruppe, Ton) sorgen schnell für völlig neue Ideen.
                </p>
            </div>
        </div>
    </div>

    <div class="footer-box">
        © <?= date('Y') ?> <a href="https://thecodeatlas.net" target="_blank" rel="noopener">
            TheCodeAtlas.net – Tools für Webmaster, Kreative & SEOs
        </a>
    </div>
</div>

<script>
function copyPrompt() {
    const box = document.getElementById('promptBox');
    if (!box) return;
    const text = box.innerText || box.textContent || '';
    if (!navigator.clipboard) {
        // Fallback (ältere Browser)
        const tmp = document.createElement('textarea');
        tmp.value = text;
        document.body.appendChild(tmp);
        tmp.select();
        document.execCommand('copy');
        document.body.removeChild(tmp);
        alert('Prompt kopiert');
        return;
    }
    navigator.clipboard.writeText(text)
        .then(() => alert('Prompt kopiert'))
        .catch(() => alert('Kopieren nicht möglich'));
}
</script>

</body>
</html>
