<?php
/*
===========================================================
 OpenGraph Image Generator – ULTRA Trial Edition
 Idee & Umsetzung: Rainer Wieding – https://thecodeatlas.net
 Technische Unterstützung: ChatGPT (OpenAI)
===========================================================
*/
error_reporting(E_ALL);
ini_set('display_errors', 1);
?>
<!DOCTYPE html>
<html lang="de">
<head>
<meta charset="utf-8">
<title>OpenGraph Image Generator – Ultra Edition (Trial)</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">

<style>
body {
    background: radial-gradient(circle at top, #1e1b4b 0, #020617 45%, #020617 100%);
    min-height: 100vh;
    color: #e5e7eb;
    font-family: system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
}

.card-glass {
    background: rgba(15, 23, 42, 0.95);
    border-radius: 18px;
    border: 1px solid rgba(148, 163, 184, 0.4);
    box-shadow: 0 22px 60px rgba(15, 23, 42, 0.85);
}

.form-label {
    color: #aebac9;
    font-weight: 600;
    font-size: 0.9rem;
}

input::placeholder,
textarea::placeholder {
    color: #4b5563 !important; /* etwas dunkler, besser lesbar */
    opacity: 1 !important;
}

input,
textarea,
select {
    color: #1f2937 !important;
}

/* Preview Wrapper */
#previewFrame {
    background: #020617;
    border-radius: 16px;
    padding: 18px;
    border: 1px solid rgba(148, 163, 184, 0.5);
    display: flex;
    justify-content: center;
    align-items: center;
}

/* OG Preview Canvas Root */
.og-preview {
    position: relative;
    border-radius: 24px;
    overflow: hidden;
    color: #f9fafb;
    display: flex;
    flex-direction: column;
    padding: 0;
    box-shadow: 0 18px 40px rgba(15, 23, 42, 0.8);
}

/* Background Layer System */
.og-bg {
    position:absolute;
    inset:0;
    z-index:0;
    overflow:hidden;
}

.og-bg-base {
    position:absolute;
    inset:0;
    background:linear-gradient(135deg, #312e81, #1e293b);
    transform:scale(1.02);
}

.og-bg-image {
    position:absolute;
    inset:0;
    background-size:cover;
    background-position:center;
    filter:blur(var(--bg-blur, 0px));
    opacity:var(--bg-image-opacity, 1);
    transform:scale(1.05);
}

.og-bg-overlay {
    position:absolute;
    inset:0;
    background:rgba(15,23,42,0.75);
    opacity:var(--bg-overlay-opacity, 0.45);
}

/* Content Wrapper */
.og-content {
    position:relative;
    z-index:1;
    display:flex;
    flex-direction:column;
    padding:32px;
    height:100%;
}

/* Formate (Preview-Verhältnis) */
.og-format-1200x630 {
    width: 960px;
    height: 504px;
}
.og-format-1200x628 {
    width: 960px;
    height: 502px;
}
.og-format-1080x1080 {
    width: 480px;
    height: 480px;
}

/* Generelle Elemente */
.og-top-row {
    display: flex;
    justify-content: space-between;
    align-items: center;
    gap: 12px;
    font-size: 0.8rem;
    text-transform: uppercase;
    letter-spacing: .12em;
}

.og-category-badge {
    padding: 4px 10px;
    border-radius: 999px;
    background: rgba(15, 23, 42, 0.6);
    border: 1px solid rgba(148, 163, 184, 0.7);
    font-weight: 600;
}

.og-domain {
    opacity: 0.9;
}

.og-main {
    flex: 1;
    display: flex;
    flex-direction: column;
    justify-content: center;
    gap: 10px;
    margin-top: 18px;
}

.og-title {
    font-size: 2.2rem;
    line-height: 1.15;
    font-weight: 800;
}

.og-subtitle {
    font-size: 1rem;
    max-width: 80%;
    opacity: 0.9;
}

.og-logo-wrap {
    position: absolute;
    right: 26px;
    bottom: 24px;
    width: 96px;
    height: 96px;
    border-radius: 20px;
    background: rgba(15, 23, 42, 0.7);
    display: flex;
    justify-content: center;
    align-items: center;
    overflow: hidden;
    border: 1px solid rgba(148, 163, 184, 0.7);
}
.og-logo-wrap img {
    max-width: 100%;
    max-height: 100%;
}

/* Template-Varianten */
.template-1 .og-main {
    align-items: flex-start;
}

.template-2 .og-main {
    flex-direction: row;
    align-items: center;
    gap: 24px;
}
.template-2 .og-main-text {
    flex: 2;
}
.template-2 .og-main-accent {
    flex: 1;
    height: 70%;
    border-radius: 24px;
    background: rgba(15, 23, 42, 0.45);
}

.template-3 .og-main {
    justify-content: flex-end;
}
.template-3 .og-title {
    font-size: 2.6rem;
}

.template-4 .og-main {
    align-items: center;
    text-align:center;
}
.template-4 .og-subtitle {
    max-width: 60%;
}

.template-5 .og-content {
    padding-left: 48px;
}
.template-5 .og-content::before {
    content:"";
    position:absolute;
    left:24px;
    top:24px;
    bottom:24px;
    width:4px;
    border-radius:999px;
    background:linear-gradient(180deg, #38bdf8, #a855f7);
}

.template-6 .og-main {
    position:relative;
}
.template-6 .og-main::before {
    content:"";
    position:absolute;
    inset:0;
    background:radial-gradient(circle at 0% 0%, rgba(248,250,252,0.25), transparent 55%);
    pointer-events:none;
}

.template-7 .og-main {
    align-items:flex-start;
}
.template-7 .og-main-text {
    padding:18px 20px;
    background:rgba(15,23,42,0.65);
    border-radius:18px;
    box-shadow:0 16px 30px rgba(15,23,42,0.7);
}

.template-8 .og-top-row {
    font-size:0.75rem;
}
.template-8 .og-subtitle {
    font-size:0.95rem;
    max-width:90%;
}

/* Wasserzeichen für Trial */
.og-watermark {
    position:absolute;
    inset:0;
    display:flex;
    justify-content:center;
    align-items:center;
    font-size:3rem;
    font-weight:900;
    color:#ffffff;
    opacity:0.20;
    pointer-events:none;
    transform:rotate(-30deg);
    z-index:999;
    text-transform:uppercase;
}

/* Footer */
.footer-box {
    margin-top: 2rem;
    font-size: 0.8rem;
    color:#aebac9;
    text-align: center;
}
.footer-box a {
    color: #e5e7eb;
    text-decoration: none;
}
.footer-box a:hover {
    text-decoration: underline;
}

/* --- UNIVERSAL TEXT HELLER MACHEN --- */
body, body * {
    color: #e5e7eb !important;
}

/* Inputs, Selects wieder dunkel & gut lesbar */
input, textarea, select {
    color: #1f2937 !important;
    background-color: #ffffff !important;
    border-color: #cbd5e1 !important;
}

/* Placeholder gut sichtbar */
input::placeholder,
textarea::placeholder {
    color: #4b5563 !important;
    opacity: 1 !important;
}

/* Muted Texte (unter Labels etc.) heller */
.text-muted,
.form-text,
.small {
    color: #94a3b8 !important;
}

/* Domain oben rechts */
.og-domain {
    color: #f1f5f9 !important;
    opacity: 1 !important;
}

/* Kategorie-Badge */
.og-category-badge {
    color: #ffffff !important;
    border-color: rgba(255,255,255,0.35) !important;
}

/* Dropdown-Optionen wieder lesbar machen */
select option {
    color: #1f2937 !important;
    background: #ffffff !important;
}

/* Buttons im Formular */
.btn-ultra {
    border-radius:999px;
    font-weight:600;
}

/* Range Inputs dunkler Style */
.form-range::-webkit-slider-thumb {
    background:#38bdf8;
}
.form-range::-moz-range-thumb {
    background:#38bdf8;
}
</style>
</head>
<body>

<div class="container py-5">
    <div class="row justify-content-center mb-4">
        <div class="col-lg-10">
            <div class="d-flex flex-wrap justify-content-between align-items-center mb-3">
                <div>
                    <h1 class="h3 mb-1">OpenGraph Image Generator <span class="text-info">Ultra Edition</span> <span class="badge bg-secondary ms-2">Trial</span></h1>
                    <div class="text-muted small">
                        Live-Demo der Ultra Edition – mit Wasserzeichen & eingeschränktem Export. Ideal zum Testen der Funktionen.
                    </div>
                </div>
                <span class="badge rounded-pill text-bg-warning text-dark">
                    <i class="bi bi-lightning-charge-fill me-1"></i> Trial Version
                </span>
            </div>
        </div>
    </div>

    <div class="row justify-content-center">
        <div class="col-lg-10">
            <div class="card card-glass">
                <div class="card-body">
                    <div class="row g-4">
                        <!-- FORMULAR -->
                        <div class="col-lg-5">
                            <h5 class="mb-3">Einstellungen</h5>

                            <!-- Templates & Formate -->
                            <div class="mb-3">
                                <label class="form-label">Template</label>
                                <select id="tplSelect" class="form-select form-select-sm">
                                    <option value="template-1">Template 1 – Fokus Headline</option>
                                    <option value="template-2">Template 2 – Text & Accent Panel</option>
                                    <option value="template-3">Template 3 – Bold Headline</option>
                                    <option value="template-4">Template 4 – Center Hero (Vollversion)</option>
                                    <option value="template-5">Template 5 – Left Accent Bar (Vollversion)</option>
                                    <option value="template-6">Template 6 – Spotlight (Vollversion)</option>
                                    <option value="template-7">Template 7 – Card-in-Card (Vollversion)</option>
                                    <option value="template-8">Template 8 – News / Content (Vollversion)</option>
                                </select>
                                <div class="form-text">
                                    In der Trial sind die ersten 3 Templates freigeschaltet. Alle Templates gibt es in der Ultra Vollversion.
                                </div>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Format</label>
                                <select id="formatSelect" class="form-select form-select-sm">
                                    <option value="1200x630">1200 × 630 (Standard OG / Facebook)</option>
                                    <option value="1200x628">1200 × 628 (X / Twitter, Vollversion)</option>
                                    <option value="1080x1080">1080 × 1080 (quadratisch, Vollversion)</option>
                                </select>
                                <div class="form-text">
                                    In der Trial ist nur das Standard-Format aktiv.
                                </div>
                            </div>

                            <hr class="border-secondary-subtle">

                            <!-- Content -->
                            <div class="mb-3">
                                <label class="form-label">Titel (Headline)</label>
                                <input type="text" id="titleInput" class="form-control form-control-sm"
                                       placeholder="Beispiel: JSON-LD Generator – Strukturiere deine SEO-Daten">
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Untertitel / Tagline</label>
                                <textarea id="subtitleInput" rows="2"
                                          class="form-control form-control-sm"
                                          placeholder="Kurze Erklärung oder Nutzenversprechen in 1–2 Zeilen."></textarea>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Kategorie / Badge</label>
                                <input type="text" id="badgeInput" class="form-control form-control-sm"
                                       placeholder="z. B. SEO Tool, Blog, Tutorial">
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Website / Domain</label>
                                <input type="text" id="domainInput" class="form-control form-control-sm"
                                       placeholder="z. B. thecodeatlas.net">
                            </div>

                            <hr class="border-secondary-subtle">

                            <!-- Farben & Brand Kit -->
                            <div class="row g-3">
                                <div class="col-md-6">
                                    <label class="form-label">Primärfarbe</label>
                                    <input type="color" id="colorPrimary" class="form-control form-control-color"
                                           value="#6366f1">
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Akzentfarbe</label>
                                    <input type="color" id="colorAccent" class="form-control form-control-color"
                                           value="#a855f7">
                                </div>
                            </div>

                            <div class="mt-3 d-flex gap-2">
                                <button type="button" id="btnSaveBrandKit" class="btn btn-outline-info btn-sm btn-ultra flex-fill" disabled>
                                    <i class="bi bi-save me-1"></i> Brand-Kit speichern (Vollversion)
                                </button>
                                <button type="button" id="btnLoadBrandKit" class="btn btn-outline-light btn-sm btn-ultra flex-fill" disabled>
                                    <i class="bi bi-cloud-download me-1"></i> Brand-Kit laden (Vollversion)
                                </button>
                            </div>

                            <div class="form-text mt-1">
                                Brand-Kits sind in der Ultra Vollversion verfügbar.
                            </div>

                            <hr class="border-secondary-subtle">

                            <!-- Hintergrund & Effekte -->
                            <h6 class="mb-2">Hintergrund & Effekte</h6>

                            <div class="mb-2">
                                <label class="form-label">Hintergrundmodus</label>
                                <select id="bgMode" class="form-select form-select-sm">
                                    <option value="gradient">Gradient (Farben oben)</option>
                                    <option value="preset">Preset Theme (Vollversion)</option>
                                    <option value="image">Eigenes Bild (Vollversion)</option>
                                </select>
                                <div class="form-text">
                                    In der Trial ist nur der Gradient-Modus aktiv. Mehr Hintergründe in der Vollversion.
                                </div>
                            </div>

                            <div class="mb-2">
                                <label class="form-label">Preset Theme</label>
                                <select id="bgPreset" class="form-select form-select-sm" disabled>
                                    <option value="tech">Tech Wave</option>
                                    <option value="ocean">Ocean Gradient</option>
                                    <option value="sunset">Sunset Glow</option>
                                    <option value="darkglass">Dark Glass</option>
                                    <option value="pastel">Soft Pastel</option>
                                </select>
                            </div>

                            <div class="mb-2">
                                <label class="form-label">Eigenes Hintergrundbild</label>
                                <input type="file" id="bgImageInput" class="form-control form-control-sm" accept="image/*" disabled>
                                <div class="form-text">
                                    Hintergrundbilder sind in der Ultra Vollversion verfügbar.
                                </div>
                            </div>

                            <div class="mt-2">
                                <label class="form-label">Unschärfe Hintergrund</label>
                                <input type="range" class="form-range" id="bgBlur" min="0" max="12" step="1" value="4" disabled>
                            </div>

                            <div class="mt-2">
                                <label class="form-label">Dunkelheit / Overlay</label>
                                <input type="range" class="form-range" id="bgDarken" min="10" max="90" step="5" value="45" disabled>
                            </div>

                            <div class="mt-2">
                                <label class="form-label">Overlay-Farbe</label>
                                <input type="color" id="bgOverlayColor" class="form-control form-control-color" value="#020617" disabled>
                            </div>

                            <hr class="border-secondary-subtle">

                            <!-- Logo -->
                            <div class="mt-1">
                                <label class="form-label">Logo Upload (optional)</label>
                                <input type="file" id="logoInput" class="form-control form-control-sm"
                                       accept="image/*">
                                <div class="form-text">
                                    Wird unten rechts eingeblendet. Ideal: quadratisches Logo mit transparentem Hintergrund.
                                </div>
                            </div>

                            <div class="mt-3 d-grid">
                                <button type="button" id="btnAutoLayout" class="btn btn-outline-warning btn-ultra" disabled>
                                    <i class="bi bi-magic me-1"></i> Auto-Layout (Vollversion)
                                </button>
                            </div>

                            <hr class="border-secondary-subtle">

                            <!-- Export -->
                            <div class="mt-2 d-grid gap-2">
                                <button type="button" id="btnExportPNG" class="btn btn-success btn-ultra">
                                    <i class="bi bi-download me-1"></i> PNG exportieren (mit Wasserzeichen)
                                </button>
                                <button type="button" id="btnExportOGPack" class="btn btn-secondary btn-ultra" disabled>
                                    <i class="bi bi-archive me-1"></i> OG-Pack Export (Vollversion)
                                </button>
                            </div>

                            <div class="form-text mt-2">
                                Diese Trial-Version exportiert Bilder mit Wasserzeichen und eingeschränkter Auflösung.
                                Die Vollversion enthält zusätzlich: OG-Pack ZIP Export, mehr Formate, alle Templates,
                                Hintergrundbilder, Brand-Kits & Auto-Layout.
                            </div>

                            <div class="mt-3">
                                <a href="https://thecodeatlas.net/project.php?slug=opengraph_image_generator_ultra&lang=de" class="btn btn-outline-light btn-sm w-100">
                                    <i class="bi bi-lock-fill me-1"></i> Vollversion &amp; Preise ansehen
                                </a>
                            </div>
                        </div>

                        <!-- PREVIEW -->
                        <div class="col-lg-7">
                            <h5 class="mb-2">Live Vorschau</h5>
                            <p class="small text-muted mb-2">
                                Vorschau entspricht dem Trial-Export. In der Vollversion entfällt das Wasserzeichen,
                                die Auflösung wird erhöht und alle Funktionen werden freigeschaltet.
                            </p>

                            <div id="previewFrame">
                                <div id="ogPreview" class="og-preview template-1 og-format-1200x630">
                                    <div class="og-bg">
                                        <div class="og-bg-base" id="bgBase"></div>
                                        <div class="og-bg-image" id="bgImageLayer"></div>
                                        <div class="og-bg-overlay" id="bgOverlay"></div>
                                    </div>
                                    <!-- Wasserzeichen -->
                                    <div id="trialWatermark" class="og-watermark">TRIAL VERSION</div>
                                    <div class="og-content">
                                        <div class="og-top-row">
                                            <div class="og-category-badge" id="previewBadge">SEO Tool</div>
                                            <div class="og-domain" id="previewDomain">thecodeatlas.net</div>
                                        </div>
                                        <div class="og-main">
                                            <div class="og-main-text">
                                                <div class="og-title" id="previewTitle">
                                                    OpenGraph Image Generator – Ultra Edition
                                                </div>
                                                <div class="og-subtitle" id="previewSubtitle">
                                                    Teste die Ultra Edition live im Browser. In der Vollversion ohne Wasserzeichen, mit höherer Auflösung, mehr Templates, OG-Pack Export & Branding-Features.
                                                </div>
                                            </div>
                                            <div class="og-main-accent d-none"></div>
                                        </div>
                                        <div class="og-logo-wrap" id="logoWrap" style="display:none;">
                                            <img id="previewLogo" alt="Logo">
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <p class="small text-muted mt-2 mb-0">
                                Hinweis: Diese Trial-Version ist nur für Testzwecke gedacht. Die Vollversion erzeugt saubere,
                                hochauflösende Bilder ohne Wasserzeichen für den produktiven Einsatz.
                            </p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="footer-box">
                © <?php echo date('Y'); ?> TheCodeAtlas.net – Trial-Version der OpenGraph Ultra Edition.
                Weitergabe, Verkauf oder Veröffentlichung – vollständig oder in Teilen –
                ist ohne ausdrückliche schriftliche Genehmigung des Urhebers nicht gestattet.
            </div>

        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/html2canvas@1.4.1/dist/html2canvas.min.js"></script>

<script>
(function() {
    const trialMode = true; // fest auf Trial

    var ogPreview      = document.getElementById('ogPreview');
    var previewTitle   = document.getElementById('previewTitle');
    var previewSubtitle= document.getElementById('previewSubtitle');
    var previewBadge   = document.getElementById('previewBadge');
    var previewDomain  = document.getElementById('previewDomain');
    var logoWrap       = document.getElementById('logoWrap');
    var previewLogo    = document.getElementById('previewLogo');

    var bgBase         = document.getElementById('bgBase');
    var bgImageLayer   = document.getElementById('bgImageLayer');
    var bgOverlay      = document.getElementById('bgOverlay');

    var titleInput     = document.getElementById('titleInput');
    var subtitleInput  = document.getElementById('subtitleInput');
    var badgeInput     = document.getElementById('badgeInput');
    var domainInput    = document.getElementById('domainInput');
    var colorPrimary   = document.getElementById('colorPrimary');
    var colorAccent    = document.getElementById('colorAccent');

    var bgMode         = document.getElementById('bgMode');
    var bgPreset       = document.getElementById('bgPreset');
    var bgImageInput   = document.getElementById('bgImageInput');
    var bgBlur         = document.getElementById('bgBlur');
    var bgDarken       = document.getElementById('bgDarken');
    var bgOverlayColor = document.getElementById('bgOverlayColor');

    var logoInput      = document.getElementById('logoInput');
    var tplSelect      = document.getElementById('tplSelect');
    var formatSelect   = document.getElementById('formatSelect');
    var btnExportPNG   = document.getElementById('btnExportPNG');
    var btnExportOGPack= document.getElementById('btnExportOGPack');
    var btnSaveBrandKit= document.getElementById('btnSaveBrandKit');
    var btnLoadBrandKit= document.getElementById('btnLoadBrandKit');
    var btnAutoLayout  = document.getElementById('btnAutoLayout');

    var uploadedLogoData = null;
    var uploadedBgData   = null;

    function val(el) {
        if (!el) return '';
        return (el.value || '').trim();
    }

    function slugify(text) {
        if (!text) return '';
        return text.toLowerCase()
            .replace(/\s+/g, '-')
            .replace(/[^a-z0-9\-]/g, '')
            .replace(/\-+/g, '-')
            .replace(/^\-+|\-+$/g, '');
    }

    function updateBackground() {
        // Trial: nur einfacher Gradient aus Primär/Akzent
        var c1 = val(colorPrimary) || '#6366f1';
        var c2 = val(colorAccent) || '#a855f7';
        bgImageLayer.style.backgroundImage = 'none';
        bgImageLayer.style.opacity = '0';
        bgBase.style.background = 'linear-gradient(135deg, ' + c1 + ', ' + c2 + ')';

        bgImageLayer.style.setProperty('--bg-blur', '0px');
        bgOverlay.style.setProperty('--bg-overlay-opacity', '0.45');
        bgOverlay.style.backgroundColor = '#020617';
    }

    function updatePreview() {
        var t = val(titleInput) || 'OpenGraph Image Generator – Ultra Edition';
        var s = val(subtitleInput) || 'Teste die Ultra Edition live im Browser. In der Vollversion ohne Wasserzeichen, mit höherer Auflösung, mehr Templates, OG-Pack Export & Branding-Features.';
        var b = val(badgeInput) || 'SEO Tool';
        var d = val(domainInput) || 'thecodeatlas.net';

        previewTitle.textContent = t;
        previewSubtitle.textContent = s;
        previewBadge.textContent = b;
        previewDomain.textContent = d;

        ogPreview.classList.remove('template-1','template-2','template-3','template-4','template-5','template-6','template-7','template-8');
        var tpl = tplSelect.value || 'template-1';
        ogPreview.classList.add(tpl);

        var mainAccent = ogPreview.querySelector('.og-main-accent');
        if (mainAccent) {
            if (tpl === 'template-2') {
                mainAccent.classList.remove('d-none');
                mainAccent.style.background = 'linear-gradient(160deg, rgba(15,23,42,0.9), rgba(15,23,42,0.3))';
            } else {
                mainAccent.classList.add('d-none');
            }
        }

        // Trial: nur 1200x630
        ogPreview.classList.remove('og-format-1200x630','og-format-1200x628','og-format-1080x1080');
        ogPreview.classList.add('og-format-1200x630');

        updateBackground();
    }

    // Logo laden
    logoInput.addEventListener('change', function() {
        var file = logoInput.files && logoInput.files[0];
        if (!file) {
            logoWrap.style.display = 'none';
            previewLogo.removeAttribute('src');
            uploadedLogoData = null;
            return;
        }
        var reader = new FileReader();
        reader.onload = function(e) {
            uploadedLogoData = e.target.result;
            previewLogo.src = uploadedLogoData;
            logoWrap.style.display = 'flex';
        };
        reader.readAsDataURL(file);
    });

    titleInput.addEventListener('input', updatePreview);
    subtitleInput.addEventListener('input', updatePreview);
    badgeInput.addEventListener('input', updatePreview);
    domainInput.addEventListener('input', updatePreview);
    colorPrimary.addEventListener('input', updatePreview);
    colorAccent.addEventListener('input', updatePreview);

    tplSelect.addEventListener('change', function() {
        // Trial: nur erste 3 Templates erlaubt
        if (trialMode && tplSelect.selectedIndex > 2) {
            alert('Dieses Template ist in der Trial-Version gesperrt. In der Ultra Vollversion stehen alle Templates zur Verfügung.');
            tplSelect.selectedIndex = 0;
        }
        updatePreview();
    });

    formatSelect.addEventListener('change', function() {
        if (trialMode && formatSelect.value !== '1200x630') {
            alert('Dieses Format ist in der Trial-Version gesperrt. In der Ultra Vollversion sind alle Formate freigeschaltet.');
            formatSelect.value = '1200x630';
        }
        updatePreview();
    });

    // PNG Export (mit Trial-Einschränkung)
    btnExportPNG.addEventListener('click', function() {
        html2canvas(ogPreview, {
            backgroundColor: null,
            useCORS: true,
            scale: trialMode ? 1 : 2 // Trial: geringere Auflösung
        }).then(function(canvas) {
            canvas.toBlob(function(blob) {
                if (!blob) return;
                var a = document.createElement('a');
                var name = val(titleInput) || 'og-image-trial';
                name = slugify(name) || 'og-image-trial';
                var url = URL.createObjectURL(blob);
                a.href = url;
                a.download = name + '-trial.png';
                a.click();
                URL.revokeObjectURL(url);
            });
        });
    });

    // OG-Pack in Trial gesperrt
    btnExportOGPack.addEventListener('click', function() {
        alert('Der OG-Pack Export (Facebook / X / LinkedIn) ist nur in der Ultra Vollversion verfügbar.');
    });

    // Trial-spezifische Sperren & Hinweise
    if (trialMode) {
        // Nur Templates 1–3 freigeben
        Array.from(tplSelect.options).forEach(function(opt, index) {
            if (index > 2) {
                opt.disabled = true;
            }
        });

        // Nur Format 1200x630
        Array.from(formatSelect.options).forEach(function(opt) {
            if (opt.value !== '1200x630') {
                opt.disabled = true;
            }
        });
        formatSelect.value = '1200x630';

        // Nur Gradient-Hintergrund
        bgMode.value = 'gradient';
        bgMode.addEventListener('change', function() {
            if (bgMode.value !== 'gradient') {
                alert('Andere Hintergrundmodi sind nur in der Ultra Vollversion verfügbar.');
                bgMode.value = 'gradient';
            }
        });

        // Wasserzeichen sicherheitshalber einblenden
        var wm = document.getElementById('trialWatermark');
        if (wm) wm.style.display = 'flex';
    }

    updatePreview();
})();
</script>

</body>
</html>
