<?php
$file = "urls.json";

if (!file_exists($file)) {
    file_put_contents($file, json_encode([]));
}

$data = json_decode(file_get_contents($file), true);

if (isset($_GET['u'])) {
    $url = filter_var($_GET['u'], FILTER_SANITIZE_URL);
    if (!filter_var($url, FILTER_VALIDATE_URL)) {
        die("Invalid URL");
    }

    $id = substr(md5($url.time()), 0, 6);
    $data[$id] = $url;
    file_put_contents($file, json_encode($data));

    echo "Short URL: https://example.com/?r=$id";
    exit;
}

if (isset($_GET['r'])) {
    $r = $_GET['r'];
    if (isset($data[$r])) {
        header("Location: ".$data[$r]);
        exit;
    }
}

echo "Usage: shorten.php?u=https://example.com";
