<?php
error_reporting(E_ALL);
ini_set("display_errors", 1);
header('Content-Type: application/json');

// INPUT URL
$url = $_GET['url'] ?? '';
if (!$url || !filter_var($url, FILTER_VALIDATE_URL)) {
    echo json_encode([
        "success" => false,
        "error" => "Ungültige URL"
    ]);
    exit;
}

// HTML abrufen
$html = @file_get_contents($url);

if (!$html) {
    echo json_encode([
        "success" => false,
        "error" => "Seite konnte nicht geladen werden."
    ]);
    exit;
}

// LINKS EXTRAHIEREN
preg_match_all('/<a[^>]+href=["\']?([^"\'>\s]+)/i', $html, $matches);
$links = array_unique($matches[1]);

// RELATIVE LINKS AUFLÖSEN
$parsed = parse_url($url);
$base = $parsed['scheme'] . '://' . $parsed['host'];

function normalizeUrl($href, $base) {
    // absolute
    if (preg_match('/^https?:\/\//i', $href)) {
        return $href;
    }
    // skip anchors/mail
    if (strpos($href, '#') === 0) return null;
    if (strpos($href, 'mailto:') === 0) return null;
    if (strpos($href, 'javascript:') === 0) return null;

    if (strpos($href, '/') === 0) {
        return $base . $href;
    }

    return rtrim($base, '/') . '/' . ltrim($href, '/');
}

$normalized = [];

foreach ($links as $l) {
    $n = normalizeUrl($l, $base);
    if ($n) $normalized[] = $n;
}

// ———————————————————————
// JEDEN LINK PRÜFEN
// ———————————————————————
function checkStatus($url) {
    $ch = curl_init($url);

    curl_setopt_array($ch, [
        CURLOPT_NOBODY => true,
        CURLOPT_FOLLOWLOCATION => false,
        CURLOPT_TIMEOUT => 8,
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_RETURNTRANSFER => true
    ]);

    curl_exec($ch);

    $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $errno = curl_errno($ch);

    curl_close($ch);

    if ($errno !== 0) {
        return ["status" => "Timeout", "code" => 0];
    }

    if ($code >= 200 && $code < 300)
        return ["status" => "OK", "code" => $code];

    if ($code >= 300 && $code < 400)
        return ["status" => "Redirect", "code" => $code];

    return ["status" => "Error", "code" => $code];
}

$results = [];

foreach ($normalized as $lnk) {
    $st = checkStatus($lnk);

    $results[] = [
        "url" => $lnk,
        "status" => $st["status"],
        "code" => $st["code"]
    ];
}

// OUTPUT
echo json_encode([
    "success" => true,
    "results" => $results
], JSON_PRETTY_PRINT);
